<?php
if (isset($public)  || isset($semRefrescamento)) {
	include_once '../modelo/candidatoBiblioteca.modelo.php';
}else {
	include_once 'modelo/candidatoBiblioteca.modelo.php';
}
 
class ControladorCandidatoBiblioteca
{
  
static public function ctrAddCandidatoBiblioteca($idBiblioteca, $valorPago)
{

	if (!empty($idBiblioteca)) 
	{ 
				$valorPago = addslashes($valorPago);
				$idBiblioteca = $idBiblioteca;
				$dataCadastro = addslashes(date("d-m-Y H:i:s"));
				$idUsuario = addslashes($_SESSION['ID_usuario']);
				
			$dados = array("idBiblioteca" => filter_var($idBiblioteca,FILTER_SANITIZE_STRIPPED),
				"valorPago" => filter_var($valorPago,FILTER_SANITIZE_STRIPPED), 
				"dataCadastro" => filter_var($dataCadastro,FILTER_SANITIZE_STRIPPED), 
				"idUsuario" => filter_var($idUsuario,FILTER_SANITIZE_STRIPPED));

				$verifExistencia = ControladorCandidatoBiblioteca::ctrVerificarSeOCandidatoJaTemEsteArquivoNaBiblioteca($idBiblioteca,$idUsuario);
				if ($verifExistencia == true) 
				{ 
					$resposta = ModeloCandidatoBiblioteca::mdlAddCandidatoBiblioteca($dados);

					if($resposta == "ok"){
				echo"
					<script>
					Swal.fire({
						position: 'top-end',
						icon: 'success',
						title: 'A compra foi efectuada com sucesso!',
						showConfirmButton: false,
						timer: 5000
					})
					</script>
					";	
					}else{
						echo"
						<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Não foi comprar este Arquivo',
								showConfirmButton: false,
								timer: 5000
							})
						</script>";
						
					}
				}else
				{
					echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Este Livro já foi comprado',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
					";
				}

	}
			else{
				echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Preencha os campos obrigatorios',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
				";	
			}	


}
 

static public function ctrVerificarSeOCandidatoJaTemEsteArquivoNaBiblioteca($idBiblioteca,$idUsuario){

	$resposta = ModeloCandidatoBiblioteca::mdlMostrarArquivosDoUsuarioNaBibliotecaPorIdBibliotecaEIdCandidato($idBiblioteca,$idUsuario);
	if (empty($resposta)) {
		return true;
	}
	else {
		return false;
	}
}

static public function ctrMostrarArquivosDoUsuarioNaBibliotecaPorIdBibliotecaEIdCandidato($idBiblioteca,$idUsuario){

	$resposta = ModeloCandidatoBiblioteca::mdlMostrarArquivosDoUsuarioNaBibliotecaPorIdBibliotecaEIdCandidato($idBiblioteca,$idUsuario);
	return $resposta;
}

   
static public function ctrMostrarTodoscandidatos(){

	$resposta = ModeloCandidatoVaga::mdlMostrarTodosCandidatos();
	return $resposta;
	
}

static public function ctrContarTodosCandidatos(){

	$resposta = ModeloCandidatoVaga::mdlMostrarTodosCandidatos();
	return count($resposta);
	
}


 
static public function ctrMostrarTodosConcorrentesDaVagaEidVaga($idVaga){
	$resposta = ModeloCandidatoVaga::mdlMostrarTodosConcorrentesDaVagaEidVaga($idVaga);
	return $resposta;
}

static public function ctrMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	return $resposta;
}

static public function ctrMostrarIdDaRespostaPorIdCandidatoEidVaga($idVaga,$idCandidato){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	if (empty($resposta[count($resposta)-1]["idResposta"]) || $resposta[count($resposta)-1]["idResposta"] == "") {
		return 0;
	}else {
		return ControladorResposta::ctrMostrarOIdDaPerguntaDestaRespostaPorIdResposta($resposta[count($resposta)-1]["idResposta"]);
	}
	
}

static public function ctrMostrarPontosDocandidatoPorIdCandidatoEidVaga($idVaga,$idCandidato){
	$postos = 0;
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	foreach ($resposta as $key => $value) {
		$dadoResposta = ControladorResposta::ctrMostrarRespostaPorIdResposta($value["idResposta"]);
		$postos = $postos + $dadoResposta[0]["pontuacao"];
	}
	return $postos;
	
}

static public function ctrMostrarOrdemDaPerguntaActual($idVaga,$idCandidato){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	if (empty($resposta[count($resposta)-1]["idResposta"]) || $resposta[count($resposta)-1]["idResposta"] == "") {
		return 0;
	}else {
		return ControladorPergunta::ctrMostrarOrdemDaPergunta(ControladorResposta::ctrMostrarOIdDaPerguntaDestaRespostaPorIdResposta($resposta[count($resposta)-1]["idResposta"]));
	}
	
}

 


static public function ctrMostrarTodosArquivosDaBibliotecaPoridCandidato($idUsuario){

		$resposta = ModeloCandidatoBiblioteca::mdlMostrarTodosArquivosDaBibliotecaPoridCandidato($idUsuario);

		return $resposta;

	}  

	static public function ctrActualizarEstadoCandidatoVagaPoridVagaEidCandidato($idVaga, $idCandidato, $estado){

		$resposta = ModeloCandidatoVaga::mdlActualizarEstadoCandidatoVagaPoridVagaEidCandidato($idVaga, $idCandidato, $estado);

		return $resposta;

	}
 
	static public function ctrActualizarDadosUsuarioprofessors($nome, $bi_nif, $nivelDeAcesso, $id){  

		$resposta = ModeloCandidatoVaga::mdlActualizarDadosUsuarioprofessors(addslashes($nome), addslashes($bi_nif), addslashes($nivelDeAcesso),addslashes($id));

		return $resposta;

	}

	static public function ctrActualizarImagemPerfilUsuario($imagem,$id){

		$resposta = ModeloUsuario::mdlActualizarImagemPerfilUsuario($imagem,addslashes($id));

		return $resposta;

	}

	static public function ctrActualizarCodigoParaReporSenha($idUsuario, $codigo){

		$resposta = ModeloUsuario::mdlActualizarCodigoParaReporSenha($idUsuario, $codigo);
		return $resposta;

	}
 
	static public function ctrActualizarSenhaUsuario($senhaAntiga,$id, $senha){

		$resposta = ModeloUsuario::mdlActualizarSenhaUsuario(addslashes($senhaAntiga),addslashes($id), md5(addslashes($senha)));
		return $resposta;

	}

	static public function ctrActualizarReporSenhaUsuario($senha,$id,$codigoParaReporSenha){

		$resposta = ModeloUsuario::mdlActualizarReporSenhaUsuario(md5(addslashes($senha)),$id,$codigoParaReporSenha);
		return $resposta;

	}

	static public function ctrDeletarUsuario($id){

		$resposta = ModeloUsuario::mdlDeletarUsuario(addslashes($id));
		return $resposta;

	}

}

?>